<?php
/*
Mygateway Payment Controller
By: Junaid Bhura
www.junaidbhura.com
*/

class SV_Cipg_PaymentController extends Mage_Core_Controller_Front_Action {
	// The redirect action is triggered when someone places an order
	public function redirectAction() {
		$this->loadLayout();
        $block = $this->getLayout()->createBlock('Mage_Core_Block_Template','cipg',array('template' => 'cipg/redirect.phtml'));
		$this->getLayout()->getBlock('content')->append($block);
        $this->renderLayout();
	}

	// The response action is triggered when your gateway sends back a response after processing the customer's payment
	public function responseAction() {
		if($this->getRequest()->isGet()) {

			/*
			/* Your gateway's code to make sure the reponse you
			/* just got is from the gatway and not from some weirdo.
			/* This generally has some checksum or other checks,
			/* and is provided by the gateway.
			/* For now, we assume that the gateway's response is valid
			*/

			    $merchantID= Mage::getStoreConfig('payment/cipg/merch_id');
				$orderId = $this->getRequest()->getParam('OrderID'); // Generally sent by gateway
                $transRef = $this->getRequest()->getParam('TransactionReference');
		    	$url = 'https://cipg.diamondbank.com/CustomerPortal/MerchantServices/UpayTransactionStatus.ashx';
				  $requestQuery = '';
  $requestQuery .= '?ORDER_ID='.$orderId;
  $requestQuery .= '&MERCHANT_ID='.$merchantID;
  $url .=   $requestQuery;
  //open connection
  $ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url); 
   curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
   curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, FALSE);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
curl_setopt($ch, CURLOPT_CAINFO, 'C:\wamp\www\cacert.pem');	//download cacert.pem from http://curl.haxx.se/ca/cacert.pem, place it in your server and reference location likewise here

		    	//execute post
		    	$result = curl_exec($ch);
		    	$xmlResponse = new SimpleXMLElement($result);

			    $respCode = trim($xmlResponse->StatusCode);

			    $validated = $respCode == "00";


			if($validated) {
				// Payment was successful, so update the order's state, send order email and move to the success page
				$order = Mage::getModel('sales/order');
				$order->loadByIncrementId($orderId);
				$order->setState(Mage_Sales_Model_Order::STATE_PROCESSING, true, 'Cipg has authorized the payment.');

				$order->sendNewOrderEmail();
				$order->setEmailSent(true);

				$order->save();

				Mage::getSingleton('checkout/session')->unsQuoteId();

				Mage_Core_Controller_Varien_Action::_redirect('checkout/onepage/success', array('_secure'=>true));
			}
			else {
				// There is a problem in the response we got
				$this->cancelAction();
				Mage_Core_Controller_Varien_Action::_redirect('checkout/onepage/failure', array('_secure'=>true));
			}
		}
		else
			Mage_Core_Controller_Varien_Action::_redirect('');
	}

	// The cancel action is triggered when an order is to be cancelled
	public function cancelAction() {
        if (Mage::getSingleton('checkout/session')->getLastRealOrderId()) {
            $order = Mage::getModel('sales/order')->loadByIncrementId(Mage::getSingleton('checkout/session')->getLastRealOrderId());
            if($order->getId()) {
				// Flag the order as 'cancelled' and save it
				$order->cancel()->setState(Mage_Sales_Model_Order::STATE_CANCELED, true, 'Cipg has declined the payment.')->save();
			}
        }
	}
}