<?php
class Mageist_Havale_Model_Havale extends Mage_Payment_Model_Method_Abstract
{
	protected $_code = 'havale';
	protected $_formBlockType = 'havale/form_havale';
	protected $_infoBlockType = 'havale/info_havale';

	public function assignData($data)
	{
		if (!($data instanceof Varien_Object)) {
			$data = new Varien_Object($data);
		}
		$info = $this->getInfoInstance();
		$info->setBankaAdi($data->getBankaAdi());

        Mage::getSingleton('core/session')->setBankaAdi($data->getBankaAdi());

		return $this;
	}


	public function validate()
	{
		$info = $this->getInfoInstance();
        $errorMsg = false;

		$banka = $info->getBankaAdi();

        if(empty($banka)){
            if(Mage::getSingleton('core/session')->getBankaAdi()) {
                $banka = Mage::getSingleton('core/session')->getBankaAdi();
                $info->setBankaAdi($banka);
            } else {
                $errorMsg = $this->_getHelper()->__('Havale yapacağınız bankayı seçmediniz.');
            }
		}

		if($errorMsg){
			Mage::throwException($errorMsg);
		}

		return $this;
	}
}
?>
