<?php

class Mageist_Havale_Block_Adminhtml_System_Config_Form_Field_Banks extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract {

    protected $_currencyFieldRenderer;

    public function __construct() {
        $this->addColumn('code', array(
            'label' => Mage::helper('havale')->__('Code'),
            'style' => 'width:50px',
        ));
        $this->addColumn('bank_name', array(
            'label' => Mage::helper('havale')->__('Bank Name'),
            'style' => 'width:100px',
        ));
       /* $this->addColumn('account_name', array(
            'label' => Mage::helper('havale')->__('Account Name'),
            'style' => 'width:100px',
        ));
        $this->addColumn('currency', array(
            'label' => Mage::helper('havale')->__('Currency'),
        ));
        $this->addColumn('iban', array(
            'label' => Mage::helper('havale')->__('IBAN'),
            'style' => 'width:100px',
        ));*/
        $this->_addAfter = false;
        //$this->_addButtonLabel = Mage::helper('sendloop')->__('Add field');
        parent::__construct();
    }

    protected function _prepareArrayRow(Varien_Object $row) {
        $row->setData(
                'option_extra_attr_' . $this->_currencyFieldRenderer->calcOptionHash(
                        $row->getData('currency')), 'selected="selected"'
        );
    }

    protected function setDropdownFieldRenderers() {
        if (empty($this->_currencyFieldRenderer)) {
            $this->_currencyFieldRenderer = $this->getLayout()
                    ->createBlock('core/html_select')
                    ->setIsRenderToJsTemplate(true);
        }
    }

    protected function _renderCellTemplate($columnName) {

        $this->setDropdownFieldRenderers();

        $inputName = $this->getElement()->getName() . '[#{_id}][' . $columnName . ']';

        switch ($columnName) {
            case 'currency':
                return $this->_currencyFieldRenderer
                                ->setName($inputName)
                                ->setTitle($columnName)
                                ->setExtraParams('style="width:120px"')
                                ->setOptions(
                                        array(
                                            'try' => Mage::helper('havale')->__('TRY'),
                                            'eur' => Mage::helper('havale')->__('EUR'),
                                            'usd' => Mage::helper('havale')->__('USD'),
                                            'gbp' => Mage::helper('havale')->__('GBP'),
											'nra' => Mage::helper('havale')->__('NRA'),
                                        )
                                )
                                ->toHtml();
                break;
            default:
                return parent::_renderCellTemplate($columnName);
                break;
        }
    }

}